/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or 
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */


#include <stdlib.h>
#include <stdio.h>
#include <sys/ioctl.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <asm/types.h>
#include <fcntl.h>
#include <unistd.h>
#include <linux/hiddev.h>
#include <time.h>
#include <linux/input.h>

#include <linux/ioctl.h>
#include "iowarrior.h"


int main (int argc, char **argv) {

	int fd1 = -1;

	if(( fd1 = open( "/dev/usb/iowarrior1", O_RDWR)) < 0 )
	{
		perror( "iowarrior1 open" );
		exit( 1 );
	}

	char buffer[8];
	buffer[0] = 0x04;		/* Report ID $04 for LCD enable/disable */
	buffer[1] = 0x01;		/* enable LCD function */
	buffer[2] = 0x00;
	buffer[3] = 0x00;
	buffer[4] = 0x00;
	buffer[5] = 0x00;
	buffer[6] = 0x00;
	buffer[7] = 0x00;

	/* Enable LCD function */
	if( ioctl( fd1, IOW_WRITE, buffer ))
	{
		perror( "evdev ioctl" );
		goto end;
	}

	printf( "waiting... " );
	char answer;
	scanf( "%c\n", &answer );

	buffer[1] = 0x00;
	ioctl( fd1, IOW_WRITE, buffer );

end:
	close( fd1 );
	exit( 0 );
}
